;****************************************************************
;
; MSX SUBROUTINES ver 1.0 (C) Electric Adventures 2015
;
;****************************************************************

; Set address called inside NMI routine
; HL = Hook Address
SET_VDU_HOOK:
   LD A,0cdh
   LD (VDU_HOOK),A
   LD (VDU_HOOK+1),HL
   LD A,0c9h
   LD (VDU_HOOK+3),A
   RET

; Disable the generation of NMI calls
DISABLE_NMI:
	ld      a,(0f3e0h)
	and     0dfh
DNMI1:
	ld      c,a
	ld      b,1
	jp      WRITE_REGISTER

; Enable the generation of NMI calls
ENABLE_NMI:
	ld      a,(0f3e0h)
	or      020h
	call    DNMI1
	jp      WRITE_REGISTER

; Write to VDP, port in B, value in C
WRTVDP:
    LD A,B
    OUT (CTRL_PORT),A
    LD A,C
    OR 80h
    OUT (CTRL_PORT),A
    ; copy current register value to RAM
    PUSH HL
    LD A,B
    LD B,0
    LD HL,0F3DFh
    ADD HL,BC
    LD (HL),A
    POP HL
    RET

; Set write to Video Ram
; HL = VRAM Address
SETWRT:
    LD A,L
    OUT (CTRL_PORT),A
    LD A,H
    AND 3Fh
    OR 40h
    OUT (CTRL_PORT),A
    RET
;
; Set read to Video Ram
; HL = VRAM Address
SETRD:
    LD A,L
    OUT (CTRL_PORT),A
    LD A,H
    AND 3Fh
    OUT (CTRL_PORT),A
    RET

; Load a block of memory to VRAM
; HL = VRAM Address
; DE = RAM Address
; BC = Length
LDIRVM:
    CALL SETWRT
LLOOP:
    LD A,(DE)
    OUT (DATA_PORT),A
    INC DE
    DEC BC
    LD A,C
    OR B
    CP 0
    JR NZ,LLOOP
    RET

; Fill a section of VRAM with value in A
; HL = VRAM Address
; BC = Length
FILVRM:
    LD E,A
    CALL SETWRT
FLOOP:
    LD A,E
    OUT (DATA_PORT),A
    DEC BC
    LD A,C
    OR B
    CP 0
    JR NZ,FLOOP
    RET

;
; Write Sprite positions to VRAM
; Writes sprites in normal order for 1st call and then
; reverse order for 2nd call.  Allows 8 sprites per line
; with minimal flickering.
SPRWRT:
    LD A,(SPRORDER)
    BIT 0,A
    JR NZ,SW1
    ; write sprites normal order
    SET 0,A
    LD (SPRORDER),A
    LD HL,VRAM_SPRATTR
    LD DE,SPRTBL
    LD BC,80h
    CALL LDIRVM
    RET
SW1:
    ; write sprites reverse order
    RES 0,A
    LD (SPRORDER),A
    LD HL,VRAM_SPRATTR
    CALL SETWRT
    LD IX,SPRTBL+80h-4
    LD B,32
SW2:
    LD A,(IX+0)
    OUT (DATA_PORT),A
    LD A,(IX+1)
    OUT (DATA_PORT),A
    LD A,(IX+2)
    OUT (DATA_PORT),A
    LD A,(IX+3)
    OUT (DATA_PORT),A
    DEC IX
    DEC IX
    DEC IX
    DEC IX
    DJNZ SW2
    RET

READ_REGISTER:
    IN A,(CTRLR_PORT)
    RET

WRITE_REGISTER:
    DI
    LD A,C
    OUT (CTRL_PORT),A
    LD A,B
    AND 07h
    OR 080h
    OUT (CTRL_PORT),A
    EI
    ; copy current register value to RAM
    PUSH HL
    LD A,C
    LD C,B
    LD B,0
    LD HL,0F3DFh
    ADD HL,BC
    LD (HL),A
    POP HL
    RET

; Setup Screen 2,2 - Interrupts are disabled
SETSCREEN2:
    LD HL,00101h
	LD (BAKCLR),HL
	LD IX,0005Fh
	LD IY,0
	LD A,2
	CALL 0001Ch
	LD A,(RG1SAV)
	OR 2
	LD B,A
	LD C,1
	lD IX,00047h
	LD IY,0
	CALL 0001Ch
    RET

; Clear the sprites from the screen (set Y=209)
CLEARSPRITES:
	LD B,80h
	LD DE,SPRTBL
CS1:
    LD A,209
	LD (DE),A
	INC DE
	DEC B
	LD A,B
	CP 0
	JR NZ,CS1

; Clear the VDP Pattern table (clears screen)
CLEARPAT:
	LD HL,VRAM_NAME
	LD BC,768
	XOR A
	CALL FILVRM
    RET

JOYTST:
    LD IX,000D8h
	LD IY,0
	LD A,1
	CALL 0001Ch
	PUSH AF
	XOR A
	CALL 0001Ch
	LD B,A
	POP AF
	OR B
	RET

; Check joystick 1 button
; Bit 0 of A is set if Joystick 1, button 1 is pressed
JOYTST1:
    LD IX,000D8h
	LD IY,0
	XOR A
	CALL 0001Ch
	RET

; Check joystick 2 button
; Bit 0 of A is set if Joystick 2, button 1 is pressed
JOYTST2:
    LD IX,000D8h
	LD IY,0
	LD A,1
	CALL 0001Ch
	RET


; Get joystick direction
; Result in A
; Each bit is cleared if signal is true
; Bit 0 - Joystick 1 is up
; Bit 1 - Joystick 1 is down
; Bit 2 - Joystick 1 is left
; Bit 3 - Joystick 1 is right
JOYDIR:
    LD IX,000D5h
	LD IY,0
	LD A,1
	CALL 0001Ch
	PUSH AF
	XOR A
	CALL 0001Ch
	LD B,A
	POP AF
	OR B
    RET

; Play a sound from a double byte stream of data
; byte 1 = register
; byte 2 = value
SOUND:
    LD A,(HL)
	CP 255
	RET Z
	OUT (PSG_LATCH),A
	INC HL
	CP 7
	LD A,(HL)
	JR NZ,SNDLP1
	; preserve bits 6 & 7 of register 7
	LD B,A
	IN A,(PSG_READ)
	AND 192
	ADD A,B
SNDLP1:	
    OUT (PSG_WRITE),A
	INC HL
	JR SOUND

; NMI Interrupt Routine
; Non maskable interrupt used for:
;   music, processing timers, sprite motion processing
NMI:
	; write sprite table
    CALL    SPRWRT
    LD A,(VDU_HOOK)
    CP 0cdh
    JR NZ,NMI2
    CALL VDU_HOOK
NMI2:
    CALL	TIME_MGR
NMI3:
	JP OLDINT

; Create and enable standard timers
CREATE_TIMERS:
	LD	HL,(AMERICA)	;How long a second is
	SRA L
	LD	H,0
	LD	A,1	;set to repeating
	CALL	REQUEST_SIGNAL
	LD	(HalfSecTimer),A		;Happens once per half second
	LD	HL,(AMERICA)	;How long a second is
	SRA L
	SRA L
	LD	H,0
	LD	A,1	;set to repeating
	CALL	REQUEST_SIGNAL
	LD	(QtrSecTimer),A		;Happens once per quarter second
	LD	HL,1
	LD	A,1	;set to repeating
	CALL	REQUEST_SIGNAL
	LD	(TickTimer),A		;Happens once per tick
    RET

;
; Timer Routines
;

DONE:    EQU 7
REPEAT:  EQU 6
FREE:    EQU 5
EOT:     EQU 4
LONG:    EQU 3
AMERICA: DB 50

TIME_MGR:
    ld HL,(TIMER_TABLE_BASE)
NEXT_TIMER0:
    bit FREE,(HL)
    call z,DCR_TIMER
    bit EOT,(HL)
    jr nz,SCRAM
    inc HL
    inc HL
    inc HL
    jr NEXT_TIMER0
SCRAM:
    ret
;
DCR_TIMER:
    push HL
    bit LONG,(HL)
    jr z,DCR_S_MODE_TBL
    bit REPEAT,(HL)
    jr nz,DCR_L_RPT_TBL
DCR_L_MODE_TBL:
    inc HL
    ld E,(HL)
    inc HL
    ld D,(HL)
    dec DE
    ld A,E
    or D
    jr nz,SAVE_2_BYTES
    pop HL
    push HL
    jr SET_DONE_BIT
;
DCR_L_RPT_TBL:
    inc HL
    ld E,(HL)
    inc HL
    ld D,(HL)
    ex de,hl
    ld e,(hl)
    inc hl
    ld d,(hl)
    dec de
    ld a,e
    or d
    jr nz,SAVE_2_BYTES
    inc hl
    ld e,(hl)
    inc hl
    ld d,(hl)
    dec hl
    dec hl
    ld (hl),d
    dec hl
    ld (hl),e
    pop hl
    push hl
    jr SET_DONE_BIT
;
DCR_S_MODE_TBL:
    inc hl
    dec (hl)
    jr nz,TIMER_EXIT
    pop hl
    push hl
    bit REPEAT,(hl)
    jr z,SET_DONE_BIT
    inc hl
    inc hl
    ld a,(hl)
    dec hl
    ld (hl),a
    dec hl
    pop hl
    push hl
SET_DONE_BIT:
    set DONE,(hl)
TIMER_EXIT:
    pop hl
    ret
;
SAVE_2_BYTES:
    ld (hl),d
    dec hl
    ld (hl),e
    jr TIMER_EXIT
;
; Procedure Init Timer
; HL has address of Timer table
; DE has address of Timer Data table
;
INIT_TIMER_PARAM:
    dw 00002h
    dw 00002h
    dw 00002h
;
INIT_TIMER:
    ld (TIMER_TABLE_BASE),hl
    ld (hl),030h
    ex de,hl
    ld (NEXT_TIMER_DATA_BYTE),hl
    ret
;
FREE_SIGNAL:
    ld c,a
    ld hl,(TIMER_TABLE_BASE)
    ld b,a
    ld de,00003h
    or a
    jr z,FREE_MATCH
FREE1:
    bit EOT,(hl)
    jr nz,FREE_EXIT
    add hl,de
    dec c
    jr nz,FREE1
FREE_MATCH:
    bit FREE,(hl)
    jr nz,FREE_SET
    set FREE,(hl)
    bit REPEAT,(hl)
    jr z,FREE_SET
    bit LONG,(hl)
    jr z,FREE_SET
; FREE (DELETE) COUNTER
; Counter address in DE
FREE_COUNTER:
    inc hl
    ld e,(hl)
    inc hl
    ld d,(hl)
    push de
    ld hl,(TIMER_TABLE_BASE)
    push hl
NEXT:
    bit EOT,(hl)
    jr nz,MOVE_IT
    bit FREE,(hl)
    jr nz,GET_NEXT
    ld a,(hl)
    and 048h
    cp 048h
    jr nz,GET_NEXT
    inc hl
    inc hl
    ld a,(hl)
    cp d
    jr c,GET_NEXT
    jr nz,SUBSTRACT_4
    dec hl
    ld a,(hl)
    cp e
    jr c,GET_NEXT
    jr z,FREE_EXIT
    inc hl
SUBSTRACT_4:
    ld d,(hl)
    dec hl
    ld e,(hl)
    dec de
    dec de
    dec de
    dec de
    ld (hl),e
    inc hl
    ld (hl),d
    ;jr GET_NEXT
;
GET_NEXT:
    pop hl
    inc hl
    inc hl
    inc hl
    push hl
    jr NEXT
;
MOVE_IT:
    ld b,000h
    or a
    pop hl
    pop de
    push hl
    ld hl,(NEXT_TIMER_DATA_BYTE)
    sbc hl,de
    ld c,l
    ld l,e
    ld h,d
    inc hl
    inc hl
    inc hl
    inc hl
    ldir
    ld bc,00008h
    sbc hl,bc
    ld (NEXT_TIMER_DATA_BYTE),hl
    pop hl
FREE_SET:
FREE_EXIT:
    ret
;
REQUEST_SIGNAL:
    ld c,a
    ex de,hl
    ld hl,(TIMER_TABLE_BASE)
    xor a
    ld b,a
TIMER1:
    bit FREE,(hl)
    jr z,NEXT_TIMER1
    push hl
    ld a,(hl)
    and 010h
    or 020h
    ld (hl),a
    xor a
    or d
    jr nz,LONG_TIMER
    or c
    jr z,NOT_A_REPEAT_TIMER
    set REPEAT,(hl)
NOT_A_REPEAT_TIMER:
    inc hl
    ld (hl),e
    inc hl
    ld (hl),e
    jr INIT_TIMER_EXIT
;
LONG_TIMER:
    set LONG,(hl)
    ld a,c
    or a
    jr z,NOT_A_LONG_REPEAT
    push de
    ex de,hl
    ld hl,(NEXT_TIMER_DATA_BYTE)
    ex de,hl
    set REPEAT,(hl)
    inc hl
    ld (hl),e
    inc hl
    ld (hl),d
    ex de,hl
    pop de
    ld (hl),e
    inc hl
    ld (hl),d
    inc hl
    ld (hl),e
    inc hl
    ld (hl),d
    inc hl
    ld (NEXT_TIMER_DATA_BYTE),hl
    jr INIT_TIMER_EXIT
;
NOT_A_LONG_REPEAT:
    inc hl
TIMER2:
    ld (hl),e
    inc hl
    ld (hl),d
    inc hl
    jr INIT_TIMER_EXIT
;
NEXT_TIMER1:
    bit EOT,(hl)
    jr nz,MAKE_NEW_TIMER
    inc hl
    inc hl
    inc hl
    inc b
    JR TIMER1
;
MAKE_NEW_TIMER:
    push de
    push hl
    inc hl
    inc hl
    inc hl
    inc b
    ld (hl),030h
    ex de,hl
    pop hl
    res EOT,(hl)
    ex de,hl
    pop de
    jr TIMER1
;
INIT_TIMER_EXIT:
    pop hl
    res FREE,(hl)
    ld a,b
    ret
;
; Procedure Test Signal
; A has the Signal number to be tested
; A value of True(1) or False(0) is returned in A
;
TEST_SIGNAL:
    ld c,a
    ld hl,(TIMER_TABLE_BASE)
    ld b,a
    ld de,00003h
    or a
    jr z,SIGNAL_MATCH
TEST1:
    bit EOT,(hl)
    jr nz,SIGNAL_FALSE
    add hl,de
    dec c
    jr nz,TEST1
SIGNAL_MATCH:
    bit FREE,(hl)
    jr nz,SIGNAL_FALSE
    bit DONE,(hl)
    jr nz,SIGNAL_TRUE
SIGNAL_FALSE:
    xor a
    jr TEST_EXIT
;
SIGNAL_TRUE:
    bit REPEAT,(hl)
    jr nz,SIGNAL_TRUE1
    set FREE,(hl)
SIGNAL_TRUE1:
    res DONE,(hl)
    ld a,001h
TEST_EXIT:
    or a
    ret

    ; Set interrupt entry
SETINTERRUPT:
	DI			; start of critical region

; Get old interrupt entry inter-slot call hook

	LD	DE,OLDINT	; get address of old int. hook saved area
	LD	HL,H.KEYI	; get address of interrupt entry hook
	LD	BC,5		; lenght of hook is 5 bytes
	LDIR			; transfer

; Which slot address is this cartridge placed?

	CALL	GETMSLT 	; get my slot address

; Set new inter-slot call of interrupt entry

	LD	(H.KEYI+1),A	; set slot address
	LD	A,0F7H		; 'RST 30H' inter-slot call operation code
	LD	(H.KEYI),A	; set new hook op-code
	LD	HL,NMI	; get our interrupt entry point
	LD	(H.KEYI+2),HL	; set new interrupt entry point
	LD	A,0C9H		; 'RET' operation code
	LD	(H.KEYI+4),A	; set operation code of 'RET'
	EI			; end of critical region
	RET

;--------------------------------------------------------
; Which slot address is the cartridge placed?
;  Entry: No
;  Action: Compute my slot address
;  Return: A = slot address
;  Modify: Flag

GETMSLT:
	PUSH	BC		; save environment
	PUSH	HL
	IN	A,(PSLTRG)	; read primary slot register
	RRCA			; move it to bit 0,1 of A
	RRCA
	AND	00000011B	; get bit 1,0
	LD	C,A		; set primary slot No.
	LD	B,0
	LD	HL,EXPTBL	; see if the slot is expanded or not
	ADD	HL,BC
	OR	(HL)		; set MSB if so
	LD	C,A
	INC	HL		; point to SLTTBL entry
	INC	HL
	INC	HL
	INC	HL
	LD	A,(HL)		; get what is currently output to
				; expansion slot register

	AND	00001100B	; get bits 3,2
	OR	C		; finally form slot address

	POP	HL		; restore environment
	POP	BC
	RET			; return to main


; Set origin in High RAM area, ensures ease of using 32k Rom
ORG 0C000h

TickTimer:    DS 1 ; Signal that 3 frames has elapsed
HalfSecTimer: DS 1 ; Signal that 1/2 second has elapsed
QtrSecTimer:  DS 1 ; Signal that 1/4 second has elapsed
SEED:	      DS 4
OLDINT:       DS 5

; Sprite positions
SPRTBL:       DS 80h
SPRORDER:     DS 1 ; Sprite write order flag

TIMER_TABLE:	    DS 16	;Pointer to timers table (16 timers)
TIMER_DATA_BLOCK:	DS 58	;Pointer to timers table for long timers

VDU_HOOK:     DS 4 ; NMI VDU Delayed writes hook

TIMER_LENGTH: DS 1
TEST_SIG_NUM: DS 1
TIMER_TABLE_BASE: DS 2
NEXT_TIMER_DATA_BYTE: DS 2

RAMSTART: EQU $ ; Setup where game specific values can start
